% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvect_o3.R
\name{solvect_o3}
\alias{solvect_o3}
\alias{solvect_o3_df}
\title{Determine disinfection credit from ozone.}
\source{
USEPA (2020) Equation 4-4 through 4-7
https://www.epa.gov/system/files/documents/2022-02/disprof_bench_3rules_final_508.pdf

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
solvect_o3(water, time, dose, kd, baffle)

solvect_o3_df(
  df,
  input_water = "defined",
  time = "use_col",
  dose = "use_col",
  kd = "use_col",
  baffle = "use_col",
  water_prefix = TRUE
)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link[=define_water]{define_water()}}. Water must include ph and temp}

\item{time}{Retention time of disinfection segment in minutes.}

\item{dose}{Ozone dose in mg/L. This value can also be the y intercept of the decay curve (often slightly lower than ozone dose.)}

\item{kd}{First order decay constant. This parameter is optional. If not specified, the default ozone decay equations will be used.}

\item{baffle}{Baffle factor - unitless value between 0 and 1.}

\item{df}{a data frame containing a water class column, which has already been computed using \code{\link[=define_water_df]{define_water_df()}}.}

\item{input_water}{name of the column of Water class data to be used as the input for this function. Default is "defined_water".}

\item{water_prefix}{name of the input water used for the calculation will be appended to the start of output columns. Default is TRUE.}
}
\value{
\code{solvect_o3} returns a data frame containing actual CT (mg/L*min), giardia log removal, virus log removal, and crypto log removal.

\code{solvect_o3_df} returns a data frame containing the original data frame and columns for required CT, actual CT, and giardia log removal.
}
\description{
This function takes a water defined by \code{\link[=define_water]{define_water()}} and the first order decay curve parameters
from an ozone dose and outputs a dataframe of actual CT, and log removal for giardia, virus, and crypto.
For a single water, use \code{solvect_o3}; to apply the model to a dataframe, use \code{solvect_o3_df}.
For most arguments, the \verb{_df} helper
"use_col" default looks for a column of the same name in the dataframe. The argument can be specified directly in the
function instead or an unquoted column name can be provided.
}
\details{
First order decay curve for ozone has the form: \code{residual = dose * exp(kd*time)}. kd should be a negative number.
Actual CT is an integration of the first order curve. The first 30 seconds are removed from the integral to account for
instantaneous demand.

When \code{kd} is not specified, a default decay curve is used from the Water Treatment Plant Model (2002). This model does
not perform well for ozone decay, so specifying the decay curve is recommended.
}
\examples{

# Use kd from experimental data (recommended):
define_water(ph = 7.5, temp = 25) \%>\%
  solvect_o3(time = 10, dose = 2, kd = -0.5, baffle = 0.9)
# Use modeled decay curve:
define_water(ph = 7.5, alk = 100, doc = 2, uv254 = .02, br = 50) \%>\%
  solvect_o3(time = 10, dose = 2, baffle = 0.5)

\donttest{
ct_calc <- water_df \%>\%
  dplyr::mutate(br = 50) \%>\%
  define_water_df() \%>\%
  dplyr::mutate(
    dose = 2,
    O3time = 10,
  ) \%>\%
  solvect_o3_df(time = O3time, baffle = .7)
}

}
