% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_water.R
\name{define_water}
\alias{define_water}
\title{Create a water class object given water quality parameters}
\source{
Crittenden et al. (2012) equation 5-38 - ionic strength from TDS

Snoeyink & Jenkins (1980) - ionic strength from conductivity

Lewis and Randall (1921), Crittenden et al. (2012) equation 5-37 - ionic strength from ion concentrations

Harned and Owen (1958), Crittenden et al. (2012) equation 5-45 - Temperature correction of dielectric constant (relative permittivity)
}
\usage{
define_water(
  ph,
  temp = 25,
  alk,
  tot_hard,
  ca,
  mg,
  na,
  k,
  cl,
  so4,
  mno4,
  free_chlorine = 0,
  combined_chlorine = 0,
  tot_po4 = 0,
  tot_nh3 = 0,
  tot_ch3coo = 0,
  tot_bo3 = 0,
  tot_sio4 = 0,
  tds,
  cond,
  toc,
  doc,
  uv254,
  br,
  f,
  fe,
  al,
  mn,
  no3
)
}
\arguments{
\item{ph}{water pH}

\item{temp}{Temperature in degree C}

\item{alk}{Alkalinity in mg/L as CaCO3}

\item{tot_hard}{Total hardness in mg/L as CaCO3}

\item{ca}{Calcium in mg/L Ca2+}

\item{mg}{Magnesium in mg/L Mg2+}

\item{na}{Sodium in mg/L Na+}

\item{k}{Potassium in mg/L K+}

\item{cl}{Chloride in mg/L Cl-}

\item{so4}{Sulfate in mg/L SO42-}

\item{mno4}{Permanganate in mg/L MnO4-}

\item{free_chlorine}{Free chlorine in mg/L as Cl2. Used when a starting water has a free chlorine residual.}

\item{combined_chlorine}{Combined chlorine (chloramines) in mg/L as Cl2. Used when a starting water has a chloramine residual.}

\item{tot_po4}{Phosphate in mg/L as PO4 3-. Used when a starting water has a phosphate residual.}

\item{tot_nh3}{Total ammonia in mg/L as N}

\item{tot_ch3coo}{Total acetate in mg/L}

\item{tot_bo3}{Total borate (B(OH)4 -) in mg/L as B}

\item{tot_sio4}{Total silicate in mg/L as SiO2}

\item{tds}{Total Dissolved Solids in mg/L (optional if ions are known)}

\item{cond}{Electrical conductivity in uS/cm (optional if ions are known)}

\item{toc}{Total organic carbon (TOC) in mg/L}

\item{doc}{Dissolved organic carbon (DOC) in mg/L}

\item{uv254}{UV absorbance at 254 nm (cm-1)}

\item{br}{Bromide in ug/L Br-}

\item{f}{Fluoride in mg/L F-}

\item{fe}{Iron in mg/L Fe3+}

\item{al}{Aluminum in mg/L Al3+}

\item{mn}{Manganese in ug/L Mn2+}

\item{no3}{Nitrate in mg/L as N}
}
\value{
define_water outputs a water class object where slots are filled or calculated based on input parameters. Water slots have different units than those input into the define_water function, as listed below.
\describe{
\item{pH}{pH, numeric, in standard units (SU).}
\item{temp}{temperature, numeric, in °C.}
\item{alk}{alkalinity, numeric, mg/L as CaCO3.}
\item{tds}{total dissolved solids, numeric, mg/L.}
\item{cond}{electrical conductivity, numeric, uS/cm.}
\item{tot_hard}{total hardness, numeric, mg/L as CaCO3.}
\item{kw}{dissociation constant for water, numeric, unitless.}
\item{alk_eq}{total alkalinity as equivalents, numeric, equivalent (eq).}
\item{carbonate_alk_eq}{carbonate alkalinity as equivalents, numeric, equivalent (eq).}
\item{phosphate_alk_eq}{phosphate alkalinity as equivalents, numeric, equivalent (eq).}
\item{ammonium_alk_eq}{ammonium alkalinity as equivalents, numeric, equivalent (eq).}
\item{borate_alk_eq}{borate alkalinity as equivalents, numeric, equivalent (eq).}
\item{silicate_alk_eq}{silicate alkalinity as equivalents, numeric, equivalent (eq).}
\item{hypochlorite_alk_eq}{hypochlorite alkalinity as equivalents, numeric, equivalent (eq).}
\item{toc}{total organic carbon, numeric, mg/L.}
\item{doc}{dissolved organic carbon, numeric, mg/L.}
\item{bdoc}{biodegradable organic carbon, numeric, mg/L.}
\item{uv254}{light absorption at 254 nm, numeric, cm-1.}
\item{dic}{dissolved inorganic carbon, numeric, mg/L as C.}
\item{is}{ionic strength, numeric, mol/L.}
\item{na}{sodium, numeric, mols/L.}
\item{ca}{calcium, numeric, mols/L.}
\item{mg}{magnesium, numeric, mols/L.}
\item{k}{potassium, numeric, mols/L.}
\item{cl}{chloride, numeric, mols/L.}
\item{so4}{sulfate, numeric, mols/L.}
\item{mno4}{permanganate, numeric, mols/L.}
\item{no3}{nitrate, numeric, mols/L.}
\item{hco3}{bicarbonate, numeric, mols/L.}
\item{co3}{carbonate, numeric, mols/L.}
\item{h2po4}{phosphoric acid, numeric, mols/L.}
\item{hpo4}{hydrogen phosphate, numeric, mols/L.}
\item{po4}{phosphate, numeric, mols/L.}
\item{nh4}{ammonium, numeric, mol/L as N.}
\item{bo3}{borate, numeric, mol/L.}
\item{h3sio4}{trihydrogen silicate, numeric, mol/L.}
\item{h2sio4}{dihydrogen silicate, numeric, mol/L.}
\item{ch3coo}{acetate, numeric, mol/L.}
\item{h}{hydrogen ion, numeric, mol/L.}
\item{oh}{hydroxide ion, numeric, mol/L.}
\item{tot_po4}{total phosphate, numeric, mol/L.}
\item{tot_nh3}{total ammonia, numeric, mol/L.}
\item{tot_co3}{total carbonate, numeric, mol/L.}
\item{tot_bo3}{total borate, numeric, mol/L.}
\item{tot_sio4}{total silicate, numeric, mol/L.}
\item{tot_ch3coo}{total acetate, numeric, mol/L.}
\item{br}{bromide, numeric, mol/L.}
\item{bro3}{bromate, numeric, mol/L.}
\item{f}{fluoride, numeric, mol/L.}
\item{fe}{iron, numeric, mol/L.}
\item{al}{aluminum, numeric, mol/L.}
\item{mn}{manganese, numeric, mol/L.}
\item{free_chlorine}{free chlorine, numeric, mol/L.}
\item{ocl}{hypochlorite ion, numeric, mol/L.}
\item{combined_chlorine}{sum of chloramines, numeric, mol/L.}
\item{nh2cl}{monochloramine, numeric, mol/L.}
\item{nhcl2}{dichloramine, numeric, mol/L.}
\item{ncl3}{trichloramine, numeric, mol/L.}
\item{chcl3}{chloroform, numeric, ug/L.}
\item{chcl2br}{bromodichloromethane, numeric, ug/L.}
\item{chbr2cl}{dibromodichloromethane, numeric, ug/L.}
\item{chbr3}{bromoform, numeric, ug/L.}
\item{tthm}{total trihalomethanes, numeric, ug/L.}
\item{mcaa}{chloroacetic acid, numeric, ug/L.}
\item{dmcaa}{dichloroacetic acid, numeric, ug/L.}
\item{tcaa}{trichloroacetic acid, numeric, ug/L.}
\item{mbaa}{bromoacetic acid, numeric, ug/L.}
\item{dbaa}{dibromoacetic acid, numeric, ug/L.}
\item{haa5}{sum of haloacetic acids, numeric, ug/L.}
\item{bcaa}{bromochloroacetic acid, numeric, ug/L.}
\item{cdbaa}{chlorodibromoacetic acid, numeric, ug/L.}
\item{dcbaa}{dichlorobromoacetic acid, numeric, ug/L.}
\item{tbaa}{tribromoacetic acid, numeric, ug/L.}
}
}
\description{
This function takes user-defined water quality parameters and creates an S4 "water" class object that forms the input and output of all tidywater models.
}
\details{
Carbonate balance is calculated and units are converted to mol/L. Ionic strength is determined from ions, TDS, or conductivity.
Missing values are handled by defaulting to 0 or NA.
Calcium defaults to 65 percent of the total hardness when not specified. DOC defaults to 95 percent of TOC.
}
\examples{
water_missingions <- define_water(ph = 7, temp = 15, alk = 100, tds = 10)
water_defined <- define_water(7, 20, 50, 100, 80, 10, 10, 10, 10, tot_po4 = 1)

}
