% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_breaks_gg.R
\name{date_breaks_gg}
\alias{date_breaks_gg}
\title{Date breaks anchored to last data month (for ggplot)}
\usage{
date_breaks_gg(n = 6, last, decreasing = FALSE)
}
\arguments{
\item{n}{Integer; keep every n-th month counting backward from \code{last}. Default 6.}

\item{last}{Date; the last (max) date in your data. Required to ensure no break
is placed after your actual data.}

\item{decreasing}{Logical; if TRUE, return breaks in descending order. Default FALSE.}
}
\value{
A function usable in \code{scale_x_date(breaks = ...)}.
}
\description{
Create a breaks function for \code{scale_x_date()} that
always includes the last actual data month and then selects every
\code{n}th month counting backward.
}
\examples{
# Minimal reproducible example (avoid using the name `df`, which masks stats::df)
set.seed(1)
dat <- data.frame(
  date  = seq(as.Date("2023-01-01"), by = "month", length.out = 24),
  value = cumsum(rnorm(24))
)

library(ggplot2)

ggplot(dat, aes(date, value)) +
  geom_line() +
  scale_x_date(
    date_labels = "\%b\n\%Y",
    breaks = date_breaks_gg(n = 6, last = max(dat$date))
  ) +
  labs(x = NULL, y = NULL)
}
