% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull-crs.R
\name{pull_crs}
\alias{pull_crs}
\title{Extract CRS on WKT format}
\usage{
pull_crs(.data, ...)
}
\arguments{
\item{.data}{Input potentially including or representing a CRS. It could be
a \code{sf/sfc} object, a \code{SpatRaster/SpatVector} object, a \code{crs} object from
\code{\link[sf:st_crs]{sf::st_crs()}}, a character (for example a \href{https://proj.org/en/9.3/operations/projections/index.html}{proj4 string}) or a
integer (representing an \href{https://epsg.io/}{EPSG} code).}

\item{...}{ignored}
}
\value{
A WKT representation of the corresponding CRS.
}
\description{
Extract the WKT version of the CRS associated to a string, number of
sf/Spat* object.

The
\href{https://en.wikipedia.org/wiki/Well-known_text_representation_of_coordinate_reference_systems}{Well-known text (WKT)}
representation of coordinate reference systems (CRS) is a character string
that identifies precisely the arguments of each CRS. This is the current
standard used on \CRANpkg{sf} and \CRANpkg{terra} packages.
}
\details{
Although the WKT representation is the same, \CRANpkg{sf} and \CRANpkg{terra}
API slightly differs. For example, \CRANpkg{sf} can do:

\code{sf::st_transform(x, 25830)}

While \CRANpkg{sf} equivalent is:

\code{terra::project(bb, "epsg:25830")}

Knowing the WKT would help to smooth workflows when working with different
packages and object types.
}
\section{Internals}{


This is a thin wrapper of \code{\link[sf:st_crs]{sf::st_crs()}} and \code{\link[terra:crs]{terra::crs()}}.
}

\examples{

# sf objects

sfobj <- sf::st_as_sfc("MULTIPOINT ((0 0), (1 1))", crs = 4326)

fromsf1 <- pull_crs(sfobj)
fromsf2 <- pull_crs(sf::st_crs(sfobj))

# terra

v <- terra::vect(sfobj)
r <- terra::rast(v)

fromterra1 <- pull_crs(v)
fromterra2 <- pull_crs(r)

# integers
fromint <- pull_crs(4326)

# Characters
fromchar <- pull_crs("epsg:4326")


all(
  fromsf1 == fromsf2,
  fromsf2 == fromterra1,
  fromterra1 == fromterra2,
  fromterra2 == fromint,
  fromint == fromchar
)

cat(fromsf1)
}
\seealso{
\code{\link[terra:crs]{terra::crs()}}, \code{\link[sf:st_crs]{sf::st_crs()}} for knowing how these packages handle
CRS definitions.

Other helpers: 
\code{\link{compare_spatrasters}()},
\code{\link{is_grouped_spatvector}()},
\code{\link{is_regular_grid}()}
}
\concept{helpers}
