% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-coordinates.R
\name{as_coordinates}
\alias{as_coordinates}
\title{Get cell number, row and column from a \code{SpatRaster}}
\usage{
as_coordinates(x, as.raster = FALSE)
}
\arguments{
\item{x}{A \code{SpatRaster} object.}

\item{as.raster}{If \code{TRUE}, the result is a \code{SpatRaster} object with three
layers indicating the position of each cell (cell number, row and column).}
}
\value{
A \link[tibble:tbl_df-class]{tibble} or a \code{SpatRaster} (if \code{as.raster = TRUE}) with
the same number of rows (or cells) than the number of cells in \code{x}.

When \code{as.raster = TRUE} the resulting \code{SpatRaster} has the same crs,
extension and resolution than \code{x}
}
\description{
\code{as_coordinates()} can be used to obtain the position of each cell on the
\code{SpatRaster} matrix.
}
\examples{

library(terra)

f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")

r <- rast(f)

as_coordinates(r)
as_coordinates(r, as.raster = TRUE)

as_coordinates(r, as.raster = TRUE) |> plot()

}
\seealso{
\code{\link[=slice.SpatRaster]{slice.SpatRaster()}}

Coercing objects:
\code{\link{as_sf}()},
\code{\link{as_spatraster}()},
\code{\link{as_spatvector}()},
\code{\link{as_tibble.Spat}},
\code{\link{fortify.Spat}},
\code{\link{tidy.Spat}}
}
\concept{coerce}
