% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_util.R
\name{format_p}
\alias{format_p}
\title{Format p-values with significance markers}
\usage{
format_p(p, digit = 3, asterisk = FALSE)
}
\arguments{
\item{p}{A numeric p-value between 0 and 1.}

\item{digit}{A numeric determine decimal. Accepts:
\itemize{
\item \code{3}:convert to 3 decimal, default
\item \code{4}:convert to 4 decimal
}}

\item{asterisk}{Logical indicating whether to return significance asterisks.}
}
\value{
Character of formatted p-value or asterisks.
}
\description{
Formats p-values as strings with specified precision and optional significance asterisks.
}
\examples{
format_p(0.00009, 4)
format_p(0.03, 3)
format_p(0.02, asterisk = TRUE)

}
