% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand}
\alias{expand}
\alias{crossing}
\alias{nesting}
\title{Expand data frame to include all possible combinations of values}
\usage{
expand(data, ..., .name_repair = "check_unique")

crossing(..., .name_repair = "check_unique")

nesting(..., .name_repair = "check_unique")
}
\arguments{
\item{data}{A data frame.}

\item{...}{<\code{\link[=tidyr_data_masking]{data-masking}}> Specification of columns
to expand or complete. Columns can be atomic vectors or lists.
\itemize{
\item To find all unique combinations of \code{x}, \code{y} and \code{z}, including those not
present in the data, supply each variable as a separate argument:
\code{expand(df, x, y, z)} or \code{complete(df, x, y, z)}.
\item To find only the combinations that occur in the
data, use \code{nesting}: \code{expand(df, nesting(x, y, z))}.
\item You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for each present school-student combination for all possible
dates.
}

When used with factors, \code{\link[=expand]{expand()}} and \code{\link[=complete]{complete()}} use the full set of
levels, not just those that appear in the data. If you want to use only the
values seen in the data, use \code{forcats::fct_drop()}.

When used with continuous variables, you may need to fill in values
that do not appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = full_seq(year,1)}.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}}
for the meaning of these options.}
}
\description{
\code{expand()} generates all combination of variables found in a dataset.
It is paired with \code{nesting()} and \code{crossing()} helpers. \code{crossing()}
is a wrapper around \code{\link[=expand_grid]{expand_grid()}} that de-duplicates and sorts its inputs;
\code{nesting()} is a helper that only finds combinations already present in the
data.

\code{expand()} is often useful in conjunction with joins:
\itemize{
\item use it with \code{right_join()} to convert implicit missing values to
explicit missing values (e.g., fill in gaps in your data frame).
\item use it with \code{anti_join()} to figure out which combinations are missing
(e.g., identify gaps in your data frame).
}
}
\section{Grouped data frames}{

With grouped data frames created by \code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{expand()} operates
\emph{within} each group. Because of this, you cannot expand on a grouping column.
}

\examples{
# Finding combinations ------------------------------------------------------
fruits <- tibble(
  type = c("apple", "orange", "apple", "orange", "orange", "orange"),
  year = c(2010, 2010, 2012, 2010, 2011, 2012),
  size = factor(
    c("XS", "S", "M", "S", "S", "M"),
    levels = c("XS", "S", "M", "L")
  ),
  weights = rnorm(6, as.numeric(size) + 2)
)

# All combinations, including factor levels that are not used
fruits |> expand(type)
fruits |> expand(size)
fruits |> expand(type, size)
fruits |> expand(type, size, year)

# Only combinations that already appear in the data
fruits |> expand(nesting(type))
fruits |> expand(nesting(size))
fruits |> expand(nesting(type, size))
fruits |> expand(nesting(type, size, year))

# Other uses ----------------------------------------------------------------
# Use with `full_seq()` to fill in values of continuous variables
fruits |> expand(type, size, full_seq(year, 1))
fruits |> expand(type, size, 2010:2013)

# Use `anti_join()` to determine which observations are missing
all <- fruits |> expand(type, size, year)
all
all |> dplyr::anti_join(fruits)

# Use with `right_join()` to fill in missing rows (like `complete()`)
fruits |> dplyr::right_join(all)

# Use with `group_by()` to expand within each group
fruits |>
  dplyr::group_by(type) |>
  expand(year, size)
}
\seealso{
\code{\link[=complete]{complete()}} to expand list objects. \code{\link[=expand_grid]{expand_grid()}}
to input vectors rather than a data frame.
}
