% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{norm_wattfab}
\alias{norm_wattfab}
\title{Watt & Fabricius Normalize}
\usage{
norm_wattfab(
  .data,
  ...,
  .by = NULL,
  .by_formant = TRUE,
  .drop_orig = FALSE,
  .keep_params = FALSE,
  .names = "{.formant}_wf",
  .silent = opt("tidynorm.silent")
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.by_formant}{Ignored by this procedure}

\item{.drop_orig}{Whether or not to drop the original formant data columns.}

\item{.keep_params}{Whether or not to keep the Location (\verb{*_.L}) and Scale
(\verb{*_.S}) normalization parameters}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Suppress normalization information messages when running a \verb{norm_*()} function. (Defaults to \code{FALSE}, overwritable using option 'tidynorm.silent' or environment variable 'R_TIDYNORM_TIDYNORM_SILENT')}
}
\value{
A data fame of Watt & Fabricius normalized formant values.
}
\description{
Watt & Fabricius Normalize
}
\details{
This is a modified version of the Watt & Fabricius Method. The original
method identified point vowels over which F1 and F2 centroids were calculated.
The procedure here just identifies centroids by taking the mean of
all formant values.

\deqn{
\hat{F}_{ij} = \frac{F_{ij}}{S_i}
}

\deqn{
 S_i = \frac{1}{N}\sum_{j=1}^N F_{ij}
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
ggplot2_inst <- require(ggplot2)

speaker_data_wattfab <- speaker_data |>
  norm_wattfab(
    F1:F3,
    .by = speaker,
    .names = "{.formant}_wf"
  )

if (ggplot2_inst) {
  ggplot(
    speaker_data_wattfab,
    aes(
      F2_wf,
      F1_wf,
      color = speaker
    )
  ) +
    stat_density_2d(
      bins = 4
    ) +
    scale_color_brewer(
      palette = "Dark2"
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    coord_fixed()
}
}
\references{
Watt, D., & Fabricius, A. (2002). Evaluation of a technique for improving the
mapping of multiple speakers’ vowel spaces in the F1 ~ F2 plane.
Leeds Working Papers in Linguistics and Phonetics, 9, 159–173.
}
