% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-neural-networks.R
\name{tl_tune_nn}
\alias{tl_tune_nn}
\title{Tune a neural network model}
\usage{
tl_tune_nn(
  data,
  formula,
  is_classification = FALSE,
  sizes = c(1, 2, 5, 10),
  decays = c(0, 0.001, 0.01, 0.1),
  folds = 5,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{sizes}{Vector of hidden layer sizes to try}

\item{decays}{Vector of weight decay parameters to try}

\item{folds}{Number of cross-validation folds (default: 5)}

\item{...}{Additional arguments to pass to nnet()}
}
\value{
A list with the best model and tuning results
}
\description{
Tune a neural network model
}
