% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{tl_plot_influence}
\alias{tl_plot_influence}
\title{Plot influence diagnostics}
\usage{
tl_plot_influence(
  model,
  plot_type = "cook",
  threshold_cook = NULL,
  threshold_leverage = NULL,
  threshold_dffits = NULL,
  n_labels = 3,
  label_size = 3
)
}
\arguments{
\item{model}{A tidylearn model object}

\item{plot_type}{Type of influence plot: "cook", "leverage", "index"}

\item{threshold_cook}{Cook's distance threshold (default: 4/n)}

\item{threshold_leverage}{Leverage threshold (default: 2*(p+1)/n)}

\item{threshold_dffits}{DFFITS threshold (default: 2*sqrt((p+1)/n))}

\item{n_labels}{Number of points to label (default: 3)}

\item{label_size}{Text size for labels (default: 3)}
}
\value{
A ggplot object
}
\description{
Plot influence diagnostics
}
