% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsummary_s3_methods.R
\name{gtsummary_s3_methods}
\alias{gtsummary_s3_methods}
\alias{tbl_regression.tidycrr}
\alias{global_pvalue_fun.tidycrr}
\title{gtsummary methods}
\usage{
\method{tbl_regression}{tidycrr}(x, tidy_fun = tidycmprsk::tidy, ...)

\method{global_pvalue_fun}{tidycrr}(x, type, ...)
}
\arguments{
\item{x}{(\code{tidycrr})\cr
\code{tidycmprsk::crr()} regression object}

\item{tidy_fun}{(\code{function})\cr
Tidier function for the model. Default is \code{tidycmprsk::tidy()}.}

\item{...}{Additional arguments passed to \code{\link[broom.helpers:tidy_plus_plus]{broom.helpers::tidy_plus_plus()}}.}

\item{type}{not used}
}
\value{
gtsummary table or data frame of results
}
\description{
These functions are S3 methods for working with \code{\link[=crr]{crr()}} model
results.
\itemize{
\item \code{tbl_regression.tidycrr()}: This function sets the tidycmprsk tidier for \code{crr()} models.
\item \code{global_pvalue_fun.tidycrr()}: This function ensures that \code{gtsummary::add_global_p(anova_fun)} uses
the Wald test by default (instead of \code{car::Anova()}, which does not support this model type).
The Wald test is executed with \code{cardx::ard_aod_wald_test()}, which wraps \code{aod::wald.test()}.
}
}
\examples{
crr(Surv(ttdeath, death_cr) ~ age + grade, trial) |>
  gtsummary::tbl_regression() |>
  gtsummary::add_global_p() |>
  gtsummary::as_gt()
}
