% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment}
\alias{segment}
\alias{segment.tbl_ts}
\alias{segment.xts}
\alias{segment.numeric}
\alias{segment.ts}
\title{Segment a time series using a variety of algorithms}
\usage{
segment(x, method = "null", ...)

\method{segment}{tbl_ts}(x, method = "null", ...)

\method{segment}{xts}(x, method = "null", ...)

\method{segment}{numeric}(x, method = "null", ...)

\method{segment}{ts}(x, method = "null", ...)
}
\arguments{
\item{x}{a numeric vector coercible into a \link[stats:ts]{stats::ts} object}

\item{method}{a character string indicating the algorithm to use. See Details.}

\item{...}{arguments passed to methods}
}
\value{
An object of class \linkS4class{tidycpt}.
}
\description{
A wrapper function that encapsulates various algorithms for detecting changepoint
sets in univariate time series.
}
\details{
Currently, \code{\link[=segment]{segment()}} can use the following algorithms, depending
on the value of the \code{method} argument:
\itemize{
\item \code{pelt}: Uses the PELT algorithm as implemented in
\code{\link[=segment_pelt]{segment_pelt()}}, which wraps either \code{\link[changepoint:cpt.mean]{changepoint::cpt.mean()}} or
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}. The \code{segmenter} is of class \code{cpt}.
\item \code{binseg}: Uses the Binary Segmentation algorithm as implemented by
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}. The \code{segmenter} is of class \code{cpt}.
\item \code{segneigh}: Uses the Segmented Neighborhood algorithm as implemented by
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}. The \code{segmenter} is of class \code{cpt}.
\item \code{single-best}: Uses the AMOC criteria as implemented by
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}. The \code{segmenter} is of class \code{cpt}.
\item \code{wbs}: Uses the Wild Binary Segmentation algorithm as implemented by
\code{\link[wbs:wbs]{wbs::wbs()}}. The \code{segmenter} is of class \code{wbs}.
\item \code{strucchange}: Uses the segmented algorithm as implemented by
\code{\link[strucchange:breakpoints]{strucchange::breakpoints()}}. The \code{segmenter} is of class \code{breakpoints}.
\item \code{selgmented}: Uses the selgmented algorithm as implemented by
\code{\link[segmented:selgmented]{segmented::selgmented()}}. The \code{segmenter} is of class \code{segmented}.
\item \code{stelpmented}: Uses the stelpmented algorithm as implemented by
\code{\link[segmented:selgmented]{segmented::stelpmented()}}. The \code{segmenter} is of class \code{stepmented}.
\item \code{cptga}: Uses the Genetic algorithm implemented by \code{\link[=segment_cptga]{segment_cptga()}}, which wraps
\code{\link[changepointGA:cptga]{changepointGA::cptga()}}. The \code{segmenter} is of class \code{tidycptga}.
\item \code{ga}: Uses the Genetic algorithm implemented by \code{\link[=segment_ga]{segment_ga()}}, which wraps
\code{\link[GA:ga]{GA::ga()}}. The \code{segmenter} is of class \code{tidyga}.
\item \code{ga-shi}: Uses the genetic algorithm implemented by \code{\link[=segment_ga_shi]{segment_ga_shi()}},
which wraps
\code{\link[=segment_ga]{segment_ga()}}. The \code{segmenter} is of class \code{tidyga}.
\item \code{ga-coen}: Uses Coen's heuristic as implemented by \code{\link[=segment_ga_coen]{segment_ga_coen()}}.
The \code{segmenter} is of class \code{tidyga}. This implementation supersedes the
following one.
\item \code{coen}: Uses Coen's heuristic as implemented by
\code{\link[=segment_coen]{segment_coen()}}. The \code{segmenter} is of class \code{\link[=seg_basket]{seg_basket()}}. Note that
this function is deprecated.
\item \code{random}: Uses a random basket of changepoints as implemented by
\code{\link[=segment_ga_random]{segment_ga_random()}}.
The \code{segmenter} is of class \code{tidyga}.
\item \code{manual}: Uses the vector of changepoints in the \code{tau} argument.
The \code{segmenter} is of class \link{seg_cpt}`.
\item \code{null}: The default. Uses no changepoints.
The \code{segmenter} is of class \link{seg_cpt}.
}
}
\examples{
# Segment a time series using PELT
segment(DataCPSim, method = "pelt")

# Segment a time series using PELT and the BIC penalty
segment(DataCPSim, method = "pelt", penalty = "BIC")

# Segment a time series using Binary Segmentation
segment(DataCPSim, method = "binseg", penalty = "BIC")

# Segment a time series using a random changepoint set
segment(DataCPSim, method = "random")

# Segment a time series using a manually-specified changepoint set
segment(DataCPSim, method = "manual", tau = c(826))

# Segment a time series using a null changepoint set
segment(DataCPSim)

}
\seealso{
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}, \code{\link[wbs:wbs]{wbs::wbs()}}, \code{\link[GA:ga]{GA::ga()}},
\code{\link[=segment_ga]{segment_ga()}}
}
