% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pums.R
\name{to_survey}
\alias{to_survey}
\title{Convert a data frame returned by get_pums() to a survey object}
\usage{
to_survey(
  df,
  type = c("person", "housing"),
  class = c("srvyr", "survey"),
  design = "rep_weights"
)
}
\arguments{
\item{df}{A data frame with PUMS person or housing weight variables, most
likely returned by \code{\link{get_pums}}.}

\item{type}{Whether to use person or housing-level weights; either
\code{"housing"} or \code{"person"} (the default).}

\item{class}{Whether to convert to a srvyr or survey object; either
\code{"survey"} or \code{"srvyr"} (the default).}

\item{design}{The survey design to use when creating a survey object.
Currently the only option is \code{"rep_weights"}.}
}
\value{
A tbl_svy or svyrep.design object.
}
\description{
This helper function takes a data frame returned by
  \code{\link{get_pums}} and converts it to a tbl_svy from the srvyr
  \code{\link[srvyr]{as_survey}} package or a svyrep.design object from the
  \code{\link[survey]{svrepdesign}} package. You can then use functions from
  the srvyr or survey to calculate weighted estimates with replicate weights
  included to provide accurate standard errors.
}
\examples{
\dontrun{
pums <- get_pums(variables = "AGEP", state = "VT", rep_weights = "person")
pums_design <- to_survey(pums, type = "person", class = "srvyr")
survey::svymean(~AGEP, pums_design)
}
}
