% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_check.R
\name{lambda_check_source}
\alias{lambda_check_source}
\title{Title: Wavelength quality control}
\usage{
lambda_check_source(
  odf,
  sample_type = c("RNA", "DNA"),
  check_level = c("strict", "lax")
)
}
\arguments{
\item{odf}{A data frame with quality attributes.}

\item{sample_type}{The type of sample under investigation.}

\item{check_level}{The level of strictness based on sample type.}
}
\value{
A vector of sample names for the different QC criteria.
}
\description{
Title: Wavelength quality control
}
\note{
Some key assumptions are made about quality for RNA or DNA.
At the moment column names is the main issue found with using this approach.
}
\examples{
fpath <- system.file("extdata", "rnaspec2018.csv", package = "tidyDenovix", mustWork = TRUE)
rna_data = read_denovix_data(fpath, file_type = 'csv')
qc_check = lambda_check_source(rna_data,sample_type='RNA',check_level='lax')
}
\author{
Tingwei Adeck
}
