% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_intelligence_classes.R
\name{pqtd}
\alias{pqtd}
\title{Prior period quarter-to-date}
\usage{
pqtd(
  .data,
  .date,
  .value,
  calendar_type = "standard",
  lag_n = 1,
  fiscal_year_start = 1
)
}
\arguments{
\item{.data}{tibble or dbi object (either grouped or ungrouped)}

\item{.date}{the date column to group by}

\item{.value}{the value column to summarize}

\item{calendar_type}{select either 'standard', '445', '454', or '544' calendar, see 'Details' for additional information}

\item{lag_n}{the number of periods to lag}

\item{fiscal_year_start}{integer 1-12, the month the fiscal year starts nearest to (default 1 = January). Only used with retail calendars ('445', '454', '544').}
}
\value{
ti object
}
\description{
\itemize{
\item This calculates the quarterly cumulative sum of targeted value using a standard or 5-5-4 calendar respecting
any groups that are passed through with \code{\link[dplyr:group_by]{dplyr::group_by()}}
}

use \link{calculate} to return the results
}
\details{
\itemize{
\item This function creates a complete calendar object that fills in any missing days, weeks, months, quarters, or years
\item If you provide a grouped object with \code{\link[dplyr:group_by]{dplyr::group_by()}}, it will generate a complete calendar for each group
\item The function creates a \code{ti} object, which pre-processes the data and arguments for further downstream functions
}

\strong{standard calendar}
\itemize{
\item The standard calendar splits the year into 12 months (with 28–31 days each) and uses a 7-day week
\item It automatically accounts for leap years every four years to match the Gregorian calendar
}

\strong{5-5-4 calendar}
\itemize{
\item The 5-5-4 calendar divides the fiscal year into 52 weeks (occasionally 53), organizing each quarter into two 5-week periods and one 4-week period.
\item This system is commonly used in retail and financial reporting
}
}
\examples{
\donttest{
pqtd(contoso::sales,.date=order_date,.value=quantity,calendar_type="standard",lag_n=1)
}
}
\seealso{
Other time_intelligence: 
\code{\link{atd}()},
\code{\link{dod}()},
\code{\link{mom}()},
\code{\link{momtd}()},
\code{\link{mtd}()},
\code{\link{mtdopm}()},
\code{\link{pmtd}()},
\code{\link{pwtd}()},
\code{\link{pytd}()},
\code{\link{qoq}()},
\code{\link{qoqtd}()},
\code{\link{qtd}()},
\code{\link{qtdopq}()},
\code{\link{wow}()},
\code{\link{wowtd}()},
\code{\link{wtd}()},
\code{\link{wtdopw}()},
\code{\link{yoy}()},
\code{\link{yoytd}()},
\code{\link{ytd}()},
\code{\link{ytdopy}()}
}
\concept{time_intelligence}
