% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{calculate}
\alias{calculate}
\title{Execute time-intelligence or segments class objects to return the underlying transformed table}
\arguments{
\item{x}{ti object}
}
\value{
dbi object
}
\description{
The \code{calculate()} function takes an object created by a time function (like \code{ytd()}, \code{mtd()}, or \code{qtd()}) or a segment function (like \code{cohort()} or \code{abc()}) and executes the underlying transformation logic.
It translates the function blueprint into an actionable query, returning the final data table.
}
\details{
The TI and segment functions in \strong{ti}—such as \code{ytd()} or \code{cohort()} and others—are designed to be \strong{lazy and database-friendly}.
They do not perform the heavy data transformation immediately.
Instead, they return a blueprint object (of class \code{ti},\code{segment_abc} or \code{segment_cohort}) that contains all the parameters and logic needed for the calculation.

\strong{\code{calculate()}} serves as the \strong{execution engine}.

When called, it interprets the blueprint and generates optimized R code or SQL code (using the \code{dbplyr} package) that is then executed efficiently on the data source, whether it's an in-memory \code{tibble} or a remote database backend (like \code{duckdb} or \code{snowflake}).
This approach minimizes data transfer and improves performance for large datasets.

The resulting table will be sorted by the relevant date column to ensure the correct temporal ordering of the calculated metrics.
}
\examples{
\donttest{
x <- ytd(contoso::sales,.date=order_date,.value=quantity,calendar_type="standard")
calculate(x)
}
}
