% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_formula.R
\name{derive_formula}
\alias{derive_formula}
\title{Derive Formulae From Augmented DAG}
\usage{
derive_formula(x, exposure, outcome, data = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{dagitty}.}

\item{exposure}{Atomic character, indicating the exposure node in \code{x}.}

\item{outcome}{Atomic character, indicating the outcome node in \code{x}.}

\item{data}{Optional, a \code{data.frame} to be used as environment for the
formulae. Default: \code{NULL}}

\item{...}{Additional arguments, passed to
\code{\link[dagitty]{adjustmentSets}}}
}
\value{
A \code{list} of objects with class \code{formula}.
}
\description{
Uses the \code{form} attribute of edges in an augmented DAG to
construct formulae for the relationship between \code{exposure} and \code{outcome}.
}
\details{
The \code{form} attribute of an augmented DAG of class \code{dagitty} should
contain information about the functional form for the relationships specified
in the DAG. For this function, the \code{form} attribute must be an additive
function as also accepted by \code{\link[stats]{formula}}. The \code{form}
attribute may contain a leading intercept and constant slopes, which will be
parsed out. If the \code{form} attribute does not meet these requirements, the
resulting \code{formula} may be invalid. For example:
\itemize{
\item \code{form=".5+x1"} would return \code{~x1}.
\item \code{form="2*x1*x2"} would return \code{~x1+x2+x1:x2}.
\item \code{form="-.2-.2*I(x3^2)"} would return \code{~I(x3^2)}.
}
}
\examples{
x <- dagitty::dagitty('dag {
C
O
X
Y
O <- X [form="I(X^2)"]
C -> X
Y -> O [form="Y*X"]
}')
f1 <- derive_formula(x, outcome = "O", exposure = "X")
f2 <- derive_formula(x, outcome = "O", exposure = "Y")
}
\seealso{
\code{\link[methods]{hasArg}}
\code{\link[tidySEM]{get_edges}}
\code{\link[dagitty]{adjustmentSets}}
}
