% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{tfest}
\alias{tfest}
\title{Helper function to create a tf object}
\usage{
tfest(
  y,
  x,
  delay = 0,
  p = 1,
  q = 2,
  um.y = NULL,
  um.x = NULL,
  n.back = NULL,
  par.prefix = "",
  envir = envir <- parent.frame()
)
}
\arguments{
\item{y}{Output series, a ts object or numeric vector.}

\item{x}{Input series, a ts object or numeric vector.}

\item{delay}{Integer. Number of periods delay (default 0).}

\item{p}{Integer. Order of the AR polynomial (default 1).}

\item{q}{Integer. Order of the MA polynomial (default 2).}

\item{um.y}{Univariate model for output series, um object or NULL.}

\item{um.x}{Univariate model for input series, um object or NULL.}

\item{n.back}{Integer. Number of backcasts to compute.}

\item{par.prefix}{Character. Prefix for parameter names.}

\item{envir}{Environment for evaluating arguments. If NULL, uses calling
environment.}
}
\value{
An object of class \code{\link{tf}} containing preestimated transfer
  function parameters.
}
\description{
\code{tfest} estimates the transfer function
 \deqn{V(B) = w_0 * (theta(B)/phi(B)) * B^d}
that relates the input X_t to the output Y_t.
}
\details{
Uses prewhitening to estimate initial parameter values.
}
\examples{
data(seriesJ)
Y <- seriesJ$Y - mean(seriesJ$Y)
X <- seriesJ$X - mean(seriesJ$X)
umx <- um(X, ar = 3)
umy <- fit(umx, Y)
tfx <- tfest(Y, X, delay = 3, p = 2, q = 2, um.x = umx, um.y = umy)

}
