% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk4.R
\name{rk4_step}
\alias{rk4_step}
\title{Runge Kutta solver for ordinary differential equations}
\usage{
rk4_step(func, dt, state)
}
\arguments{
\item{func}{The function to be numerically integrated.}

\item{dt}{Time step.}

\item{state}{A list describing the state of the function, with the first element
being 1, and the second being a tensor that represents state}
}
\value{
A list containing a new time and the numerical integration of of the
function across the time step to the new time.
}
\description{
Runge Kutta solver for ordinary differential equations
}
\examples{
\dontshow{if (reticulate::py_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
reticulate::py_module_available("tensorflow")
# example code
library(tensorflow)
ode_fun<- function(u){
  r = u ^ 3
  true_A = rbind(c(-0.1, 2.0), c(-2.0, -0.1))
  du <- r \%*\% (true_A)
  return(as.matrix(du))
}
y<- tensorflow::tf$cast(t(as.matrix(c(2, 0))), dtype = tf$float32)
x<- rk4_step(ode_fun,  dt = 0.25,
            state = list(1.0, y))
x
\dontshow{\}) # examplesIf}
}
