% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_wiki.R
\name{fetch_wiki_urls}
\alias{fetch_wiki_urls}
\title{Fetch Wikipedia page URLs by search query}
\usage{
fetch_wiki_urls(query, limit = 10)
}
\arguments{
\item{query}{Search phrase (e.g. "117th Congress").}

\item{limit}{Number of page URLs to return (default 10).}
}
\value{
A character vector of full Wikipedia article URLs.
}
\description{
Uses the MediaWiki API to get Wikipedia article URLs matching a keyword.
Does not search your local corpus; it retrieves links from Wikipedia.
Use \code{\link{read_urls}} to get article content from these URLs.
}
\examples{
\dontrun{
wiki_urls <- fetch_wiki_urls("January 6 Capitol attack")
corpus <- read_urls(wiki_urls[1])
}
}
