% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_wiki.R
\name{fetch_wiki_refs}
\alias{fetch_wiki_refs}
\title{Fetch external citation URLs from Wikipedia}
\usage{
fetch_wiki_refs(query, n = 10)
}
\arguments{
\item{query}{Search phrase (e.g. "January 6 Capitol attack").}

\item{n}{Number of citation URLs to return (default 10).}
}
\value{
A character vector of external citation URLs (prefers archived when present).
}
\description{
Searches Wikipedia for a topic, then returns external citation URLs from
the first matching page's references section. Use \code{\link{read_urls}}
to scrape content from those URLs.
}
\examples{
\dontrun{
ref_urls <- fetch_wiki_refs("January 6 Capitol attack", n = 10)
articles <- read_urls(ref_urls)
}
}
