% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{COS_TEXT}
\alias{COS_TEXT}
\title{Cosine similarity for text documents}
\usage{
COS_TEXT(
  text_vector1 = NULL,
  text_vector2 = NULL,
  threads = 1,
  separator = " "
)
}
\arguments{
\item{text_vector1}{a character string vector representing text documents (it should have the same length as the text_vector2)}

\item{text_vector2}{a character string vector representing text documents (it should have the same length as the text_vector1)}

\item{threads}{a numeric value specifying the number of cores to run in parallel}

\item{separator}{specifies the separator used between words of each character string in the text vectors}
}
\value{
a numeric vector
}
\description{
Cosine similarity for text documents
}
\details{
The function calculates the \emph{cosine} distance between pairs of text sequences of two character string vectors
}
\examples{

library(textTinyR)

vec1 = c('use this', 'function to compute the')

vec2 = c('cosine distance', 'between text sequences')

out = COS_TEXT(text_vector1 = vec1, text_vector2 = vec2, separator = " ")
}
