% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-comparison.R
\name{comparison-expectations}
\alias{comparison-expectations}
\alias{expect_lt}
\alias{expect_lte}
\alias{expect_gt}
\alias{expect_gte}
\title{Do you expect a value bigger or smaller than this?}
\usage{
expect_lt(object, expected, label = NULL, expected.label = NULL)

expect_lte(object, expected, label = NULL, expected.label = NULL)

expect_gt(object, expected, label = NULL, expected.label = NULL)

expect_gte(object, expected, label = NULL, expected.label = NULL)
}
\arguments{
\item{object, expected}{A value to compare and its expected bound.}

\item{label, expected.label}{Used to customise failure messages. For expert
use only.}
}
\description{
These functions compare values of comparable data types, such as numbers,
dates, and times.
}
\examples{
a <- 9
expect_lt(a, 10)

\dontrun{
expect_lt(11, 10)
}

a <- 11
expect_gt(a, 10)
\dontrun{
expect_gt(9, 10)
}
}
\seealso{
Other expectations: 
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{inheritance-expectations}},
\code{\link{logical-expectations}}
}
\concept{expectations}
