% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.netseries.R
\name{NetSeries}
\alias{NetSeries}
\title{A network series specification for conditional modeling.}
\usage{
NetSeries(..., order = 1, NA.impute = NULL)
}
\arguments{
\item{...}{series specification, in one of three formats:
\enumerate{
\item A list of identically- dimensioned and directed networks.
\item Several networks as arguments.
\item A \code{\link[networkDynamic:networkDynamic]{networkDynamic}} object and a numeric vector of time indices.
}}

\item{order}{how many previous networks to store as an accessible
covariate of the model.}

\item{NA.impute}{How missing dyads in transitioned-from networks
are be imputed when using conditional estimation. See argument
\code{imputers} of \code{\link[=impute.network.list]{impute.network.list()}} for details.}
}
\value{
A network object with temporal metadata.
}
\description{
A function for specifying the LHS of a temporal network series ERGM.
}
\note{
It is not recommended to modify the network returned by
\code{NetSeries} except by adding and removing edges, and even that
must be done with some care, to avoid putting it into an
inconsistent state.

It is almost always better to modify the original networks and
regenerate the series.
}
\examples{

data(samplk)

# Method 1: list of networks
monks <- NetSeries(list(samplk1,samplk2,samplk3))
ergm(monks ~ Form(~edges)+Diss(~edges))
ergm(monks ~ Form(~edges)+Persist(~edges))

# Method 2: networks as arguments
monks <- NetSeries(samplk1,samplk2,samplk3)
ergm(monks ~ Form(~edges)+Diss(~edges))
ergm(monks ~ Form(~edges)+Persist(~edges))

# Method 3: networkDynamic and time points:
## TODO

}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for specific terms.
}
