% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{undoSlabScaling}
\alias{undoSlabScaling}
\title{Postprocessing: Undo Slab Scaling}
\usage{
undoSlabScaling(Yn, pre)
}
\arguments{
\item{Yn}{the normalized tensor data. This can be, for example, the output of \code{\link{reconstructTensorBF}}.}

\item{pre}{The scaling values and mode used for preprocessing in the format as produced by \code{\link{normSlabScaling}}.}
}
\value{
The data tensor after reversing the scaling operation.
}
\description{
\code{undoSlabScaling} reverts the slabs of the \eqn{o^{th}} mode to undo the scaling effect.
}
\examples{
#Given tensor Y
\dontrun{Yscaled <- normSlabScaling(Y=Y,o=2)}
\dontrun{Yunscaled <- undoSlabScaling(Yscaled$data,Yscaled$pre)}
}
\references{
Kolda, Tamara G., and Brett W. Bader. "Tensor decompositions and applications." SIAM review 51.3 (2009): 455-500.
}
