% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ellipsoid.R
\name{plot_ellipsoid}
\alias{plot_ellipsoid}
\title{Function to plot ellipsoid models in E-space}
\usage{
plot_ellipsoid(
  x,
  y,
  z = NULL,
  xlab = "x",
  ylab = "y",
  zlab = "x",
  mve = TRUE,
  level = 0.975,
  col = NULL,
  lwd_axes = 2,
  lty_axes = 2,
  semiaxes = FALSE,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{Numeric vector representing the x coordinate of the ellipsoid.}

\item{y}{Numeric vector representing the y coordinate of the ellipsoid.}

\item{z}{Numeric vector representing the z coordinate of the ellipsoid.
Defaults to NULL.}

\item{xlab}{Character vector with the name of the x-axis label.}

\item{ylab}{Character vector with the name of the y-axis label.}

\item{zlab}{Character vector with the name of the z-axis label
(if plotting in 3D).}

\item{mve}{Logical. If \code{TRUE}, fits a minimum volume ellipsoid model.}

\item{level}{Numeric value indicating the proportion of points to be
included inside the ellipsoid model.}

\item{col}{Plot color}

\item{lwd_axes}{Line width for ellipsoid semi-axes.}

\item{lty_axes}{Line type for ellipsoid semi-axes.}

\item{semiaxes}{Logical. If \code{TRUE}, shows semi-axes of the ellipsoid.}

\item{add}{Logical. If \code{TRUE}, add plot to existing plot (for 2D plots only).}

\item{...}{Additional arguments to pass to base::plot,
rgl::plot3d, rgl::wire3d, or other plotting functions}
}
\value{
A 2-dimensional or 3-dimensional plot depending on the input
coordinates.
}
\description{
The function plots 2D and 3D ellipsoids using environmental
information as coordinates.
}
\examples{
x <- rnorm(100)
y <- rnorm(100)
z <- rnorm(100)
# 2 dimensional plot
plot_ellipsoid(x, y, col = "darkgreen", xlab = "X-axis", ylab = "Y-axis",
               mve = TRUE, level = 0.95)
# 3 dimensional plot
plot_ellipsoid(x, y, z, col = "blue", xlab = "X-axis", ylab = "Y-axis",
               zlab = "Z-axis", mve = TRUE, level = 0.95)
\donttest{
# Examples using functions of the package
library(tenm)
data("abronia")
tempora_layers_dir <- system.file("extdata/bio",package = "tenm")
abt <- tenm::sp_temporal_data(occs = abronia,
                              longitude = "decimalLongitude",
                              latitude = "decimalLatitude",
                              sp_date_var = "year",
                              occ_date_format="y",
                              layers_date_format= "y",
                              layers_by_date_dir = tempora_layers_dir,
                              layers_ext="*.tif$")
abtc <- tenm::clean_dup_by_date(abt,threshold = 10/60)
future::plan("multisession",workers=2)
abex <- tenm::ex_by_date(abtc,train_prop=0.7)
future::plan("sequential")
x <- abex$temporal_df$bio_05
y <- abex$temporal_df$bio_06
z <- abex$temporal_df$bio_12
# 2D ellipsoid
tenm::plot_ellipsoid(x = x, y=y, semiaxes= TRUE,xlim=c(140,390))
tenm::plot_ellipsoid(x = x+100, y=y, semiaxes= TRUE,add=TRUE)
# 3D ellipsoid
tenm::plot_ellipsoid(x = x, y=y, z=z ,semiaxes= FALSE)
tenm::plot_ellipsoid(x = x+100, y=y, z=z ,semiaxes= FALSE,add=TRUE)
}
}
