% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\title{Create config file if needed.}
\usage{
create_config(
  segments = list(`segment-01` = "9000000000", `segment-02` = "9000000000"),
  create_directory = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{segments}{Named List of segments ("name1" = "9000000000", ...). Default to the example version.}

\item{create_directory}{Boolean: Does the file need to be created in the project directory? Default to FALSE.}

\item{overwrite}{Boolean: if the file exist, should it be overwriten? Default to FALSE.}
}
\value{
Boolean: TRUE if the file is created, FALSE overwise (config already exists for example).
}
\description{
If you want to specify the IDs of your own sensors,
this function create a local configuration template file
in the \verb{\\inst} directory, to edit with specific information.
By default, the function doesn't create the file in the project directory
but in a temp directory. If you want to have a permanent configuration,
please use .
}
\details{
If you use the temporary options, please fill directly the name and number
of your sensors in the "segments" argument.
}
\examples{
create_config(create_directory=FALSE)
list_of_segments = list("Burel"= "9000002156", "Vitre" = "9000001844")
create_config(segments = list_of_segments,
  create_directory = FALSE,
  overwrite = TRUE) # the file already exists
}
