% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGBot.R
\docType{class}
\name{TGBot}
\alias{TGBot}
\title{TGBot}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
Package main class (implementing the Telegram bot).
}
\section{API Methods}{
 \describe{
    \item{\code{\link{forwardMessage}}}{forward messages of any
    kind} \item{\code{\link{getFile}}}{get info about a file and
    download it} \item{\code{\link{getMe}}}{test your bot's auth
    token} \item{\code{\link{getUpdates}}}{receive incoming
    updates} \item{\code{\link{getUserProfilePhotos}}}{get a list
    of profile pictures for a user}
    \item{\code{\link{sendAudio}}}{send \code{mp3} files}
    \item{\code{\link{sendDocument}}}{send general files}
    \item{\code{\link{sendLocation}}}{send point on the map}
    \item{\code{\link{sendMessage}}}{send text messages}
    \item{\code{\link{sendPhoto}}}{send image files}
    \item{\code{\link{sendSticker}}}{send \code{.webp} stickers}
    \item{\code{\link{sendVideo}}}{send \code{mp4} videos}
    \item{\code{\link{sendVoice}}}{send ogg files encoded with
    OPUS} 
    \item{\code{\link{sendPoll}}}{send a telegram poll}
    \item{\code{\link{stopPoll}}}{stop a telegram poll and obtain results}
}
}

\examples{
\dontrun{

## Without proxy
bot <- TGBot$new(token = bot_token('RBot'))

## With a proxy ...
prx <- list('url' = '123.45.6.78',
            'port' = 8080,
            'username' = 'user',
            'password' = 'password')
bot <- TGBot$new(token = bot_token('RBot'), proxy = prx)
##  .. or 
bot <- TGBot$new(token = bot_token('RBot'))
bot$set_proxy(proxy = prx)
}
}
\references{
\href{http://core.telegram.org/bots}{Bots: An
    introduction for developers} and
    \href{http://core.telegram.org/bots/api}{Telegram Bot API}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TGBot-new}{\code{TGBot$new()}}
\item \href{#method-TGBot-set_token}{\code{TGBot$set_token()}}
\item \href{#method-TGBot-set_proxy}{\code{TGBot$set_proxy()}}
\item \href{#method-TGBot-set_default_chat_id}{\code{TGBot$set_default_chat_id()}}
\item \href{#method-TGBot-req}{\code{TGBot$req()}}
\item \href{#method-TGBot-last_request}{\code{TGBot$last_request()}}
\item \href{#method-TGBot-print}{\code{TGBot$print()}}
\item \href{#method-TGBot-forwardMessage}{\code{TGBot$forwardMessage()}}
\item \href{#method-TGBot-getFile}{\code{TGBot$getFile()}}
\item \href{#method-TGBot-getMe}{\code{TGBot$getMe()}}
\item \href{#method-TGBot-getUpdates}{\code{TGBot$getUpdates()}}
\item \href{#method-TGBot-getUserProfilePhotos}{\code{TGBot$getUserProfilePhotos()}}
\item \href{#method-TGBot-sendAudio}{\code{TGBot$sendAudio()}}
\item \href{#method-TGBot-sendChatAction}{\code{TGBot$sendChatAction()}}
\item \href{#method-TGBot-sendDocument}{\code{TGBot$sendDocument()}}
\item \href{#method-TGBot-sendLocation}{\code{TGBot$sendLocation()}}
\item \href{#method-TGBot-sendMessage}{\code{TGBot$sendMessage()}}
\item \href{#method-TGBot-sendPhoto}{\code{TGBot$sendPhoto()}}
\item \href{#method-TGBot-sendSticker}{\code{TGBot$sendSticker()}}
\item \href{#method-TGBot-sendVideo}{\code{TGBot$sendVideo()}}
\item \href{#method-TGBot-sendVoice}{\code{TGBot$sendVoice()}}
\item \href{#method-TGBot-sendDice}{\code{TGBot$sendDice()}}
\item \href{#method-TGBot-sendPoll}{\code{TGBot$sendPoll()}}
\item \href{#method-TGBot-stopPoll}{\code{TGBot$stopPoll()}}
\item \href{#method-TGBot-clone}{\code{TGBot$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-new"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$new(token, proxy)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-set_token"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-set_token}{}}}
\subsection{Method \code{set_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$set_token(token)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-set_proxy"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-set_proxy}{}}}
\subsection{Method \code{set_proxy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$set_proxy(proxy)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-set_default_chat_id"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-set_default_chat_id}{}}}
\subsection{Method \code{set_default_chat_id()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$set_default_chat_id(chat_id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-req"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-req}{}}}
\subsection{Method \code{req()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$req(method = NULL, body = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-last_request"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-last_request}{}}}
\subsection{Method \code{last_request()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$last_request()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-print"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-forwardMessage"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-forwardMessage}{}}}
\subsection{Method \code{forwardMessage()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$forwardMessage(
  from_chat_id = NULL,
  message_id = NULL,
  disable_notification = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-getFile"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-getFile}{}}}
\subsection{Method \code{getFile()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$getFile(file_id, destfile = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-getMe"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-getMe}{}}}
\subsection{Method \code{getMe()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$getMe()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-getUpdates"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-getUpdates}{}}}
\subsection{Method \code{getUpdates()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$getUpdates(offset = NULL, limit = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-getUserProfilePhotos"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-getUserProfilePhotos}{}}}
\subsection{Method \code{getUserProfilePhotos()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$getUserProfilePhotos(user_id = NULL, offset = NULL, limit = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendAudio"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendAudio}{}}}
\subsection{Method \code{sendAudio()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendAudio(
  audio = NULL,
  caption = NULL,
  duration = NULL,
  performer = NULL,
  title = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendChatAction"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendChatAction}{}}}
\subsection{Method \code{sendChatAction()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendChatAction(action = NULL, chat_id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendDocument"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendDocument}{}}}
\subsection{Method \code{sendDocument()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendDocument(
  document = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendLocation"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendLocation}{}}}
\subsection{Method \code{sendLocation()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendLocation(
  latitude = NULL,
  longitude = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendMessage"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendMessage}{}}}
\subsection{Method \code{sendMessage()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendMessage(
  text = NULL,
  parse_mode = NULL,
  disable_web_page_preview = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendPhoto"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendPhoto}{}}}
\subsection{Method \code{sendPhoto()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendPhoto(
  photo = NULL,
  caption = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendSticker"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendSticker}{}}}
\subsection{Method \code{sendSticker()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendSticker(
  sticker = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendVideo"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendVideo}{}}}
\subsection{Method \code{sendVideo()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendVideo(
  video = NULL,
  duration = NULL,
  caption = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendVoice"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendVoice}{}}}
\subsection{Method \code{sendVoice()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendVoice(
  voice = NULL,
  duration = NULL,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendDice"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendDice}{}}}
\subsection{Method \code{sendDice()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendDice(disable_notification = NULL, chat_id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-sendPoll"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-sendPoll}{}}}
\subsection{Method \code{sendPoll()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$sendPoll(
  question = NULL,
  options = NULL,
  is_anonymous = TRUE,
  type = c("regular", "quiz"),
  allows_multiple_answers = FALSE,
  correct_option_id = NULL,
  is_closed = FALSE,
  disable_notification = NULL,
  reply_to_message_id = NULL,
  chat_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-stopPoll"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-stopPoll}{}}}
\subsection{Method \code{stopPoll()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$stopPoll(message_id = NULL, chat_id = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TGBot-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TGBot-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TGBot$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
