% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teda-batch.R
\name{teda_b}
\alias{teda_b}
\title{Create teda batch object from a vector}
\usage{
teda_b(observations, dist_type = "Euclidean")
}
\arguments{
\item{observations}{A vector of numeric observations}

\item{dist_type}{A string representing the distance metric to use, default
value (and currently only supported value) is "Euclidean"}
}
\value{
The teda batch object
}
\description{
Takes a vector of observations and return a teda batch object, which
holds the eccentricity and typicality values, both original and normalised
versions.
}
\details{
Uses the algorithm from Angelov (2014) to create a teda batch object.  This
contains a vector for the eccentricity (standard and normalised), typicality
(standard and normalised), the outlier threshold, and whether each observation
is or is not an outlier.  Also provides the original vector of values.
}
\examples{
vec = c(20, 12, 10)
teda_b(vec)
# same as
a = teda_b(vec,"Euclidean")
summary(a)
plot(a)

}
\references{
Angelov, P., 2014. Outside the box: an alternative data analytics framework.
Journal of Automation Mobile Robotics and Intelligent Systems, 8(2), pp.29-35.
DOI: 10.14313/JAMRIS_2-2014/16
}
\seealso{
\code{\link{teda_r}} for the recursive version of the TEDA framework.

Other TEDA.functions: \code{\link{teda_r}}
}

