% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_with_settings.R
\name{table_with_settings}
\alias{table_with_settings}
\alias{table_with_settings_ui}
\alias{table_with_settings_srv}
\title{\code{table_with_settings} module}
\usage{
table_with_settings_ui(id, ...)

table_with_settings_srv(id, table_r, show_hide_signal = reactive(TRUE))
}
\arguments{
\item{id}{An ID string that corresponds with the ID used to call the module's
UI function.}

\item{...}{(\code{character})\cr
Useful for providing additional HTML classes for the output tag.}

\item{table_r}{(\code{reactive})\cr
reactive expression that yields a table object. Supported types:
\itemize{
\item \code{rtables} objects (\code{ElementaryTable} or \code{TableTree})
\item \code{gtsummary} objects
\item \code{gt} objects (\code{gt_tbl})
}}

\item{show_hide_signal}{(\verb{reactive logical}) optional\cr
mechanism to allow modules which call this module to show/hide the table_with_settings UI.}
}
\value{
A \code{shiny} module.
}
\description{
Module designed to create a \code{shiny} table output based on table objects.
Supports \code{rtables} objects (\code{ElementaryTable} or \code{TableTree}), \code{gtsummary} objects, or \code{gt} objects.
}
\examples{
library(shiny)
library(rtables)
library(gtsummary)
library(gt)
library(magrittr)

ui <- bslib::page_fluid(
  table_with_settings_ui(id = "rtables_table"),
  table_with_settings_ui(id = "gtsummary_table"),
  table_with_settings_ui(id = "gt_table")
)

server <- function(input, output, session) {
  table_r_rtables <- reactive({
    l <- basic_table() \%>\%
      split_cols_by("ARM") \%>\%
      analyze(c("SEX", "AGE"))
    build_table(l, DM)
  })

  table_r_gtsummary <- reactive({
    gtsummary::tbl_summary(mtcars)
  })

  table_r_gt <- reactive({
    mtcars \%>\%
      gt::gt() \%>\%
      gt::tab_header(title = "Motor Trend Car Road Tests")
  })

  table_with_settings_srv(id = "rtables_table", table_r = table_r_rtables)
  table_with_settings_srv(id = "gtsummary_table", table_r = table_r_gtsummary)
  table_with_settings_srv(id = "gt_table", table_r = table_r_gt)
}

if (interactive()) {
  shinyApp(ui, server)
}

}
