% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweights_bmr.R
\name{tweights_bmr}
\alias{tweights_bmr}
\title{Function tweights_bmr}
\usage{
tweights_bmr(dataset, marginal, distance = "klqp", maxit = 1000,
  tol = 1e-08, warningcut = 0.05, silent = FALSE, Nindependent = 1)
}
\arguments{
\item{dataset}{Data frame or matrix to use to find row weights.}

\item{marginal}{Must be a named list with each element a vector of simulations of the marginal distribution of the posterior mean of data in the dataset.}

\item{distance}{The distance to minimize. Must be either 'euchlidean,' 'klqp' or 'klpq' (i.e. Kullback-Leibler). 'klqp' which is exponential tilting is recommended.}

\item{maxit}{Defines the maximum number of iterations for optimizing 'kl' distance.}

\item{tol}{Tolerance. If the achieved mean is too far from the target (i.e. as defined by tol) an error will be thrown.}

\item{warningcut}{Sets the cutoff for determining when a large weight will trigger a warning.}

\item{silent}{Allows silencing of some messages.}

\item{Nindependent}{Assumes the input also includes 'Nindependent' samples with independent columns. See details.}
}
\value{
An object of type \code{tweights}. This object conains the following components:
\describe{
  \item{Csqrt}{Matrix square root of the covariance.}
  \item{tweights}{Result from the call to tweigths.}
  \item{marginal}{Input marginal simulations.}
  \item{dataset}{Formatted dataset.}
  \item{target}{Attempted target.}
  \item{distance,maxit,tol, Nindependent, warningcut}{Inputed values to 'tweights_bmr'.}
  \item{Nindependent}{Inputed 'Nindependent' option.}
  \item{augmentWeights}{Used for 'Nindependent' option weights for each variable.}
  \item{weights}{Tilted weights for resampling}
  \item{originalTarget}{Will be null if target was not changed.}
  \item{marginal_sd}{Standard deviation of the marginals.}
}
}
\description{
Set up the needed prerequisites in order to prepare for Bayesian marginal reconstruction (including a call to tweights). Takes as input simulations from the posterior marginal distribution of variables in a dataset.
}
\details{
Reconstructs a correlated joint posterior from simulations from a marginal posterior.
The algorithm is summarized more fully in the vignettes.
The 'Nindependent' option augments the dataset by assuming some additional specified
number of patients. These patients are assumed to made up of a random bootstrapped sample
from the dataset for each variable marginally leading to independent variables.
}
\examples{
#Use winsorized marginal to keep marginal simulation within feasible bootstrap region
winsor=function(marginalSims,y)  {
  l=min(y)
  u=max(y)
  ifelse(marginalSims<l,l,ifelse(marginalSims>u,u, marginalSims))
}
#Create an example marginal posterior
marginal = list(Sepal.Length=winsor(rnorm(10000,mean=5.8, sd=.2),iris$Sepal.Length),
               Sepal.Width=winsor(rnorm(10000,mean=3,sd=.2), iris$Sepal.Width),
               Petal.Length=winsor(rnorm(10000,mean=3.7,sd=.2), iris$Petal.Length)
)

#simulate
w = tweights_bmr(dataset = iris, marginal = marginal, silent = TRUE)
post1 = post_bmr(1000, weights = w)
}
\seealso{
\code{\link{tweights}}
}
