% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{sql_collect}
\alias{sql_collect}
\title{Query and get data back into a data.frame}
\usage{
sql_collect(src, query, ...)
}
\arguments{
\item{src}{(src) An \code{src} object, result of calling \code{\link[=src_itis]{src_itis()}},
\code{\link[=src_col]{src_col()}}, or \code{\link[=src_tpl]{src_tpl()}}}

\item{query}{(character) A SQL query}

\item{...}{further args passed on to \code{\link[dplyr:tbl]{dplyr::tbl()}}}
}
\value{
A tibble with query results.
}
\description{
Execute and SQL query on a database.
}
\details{
we run \code{\link[dplyr:tbl]{dplyr::tbl()}}, then \code{\link[dplyr:compute]{dplyr::collect()}}
}
\examples{
\dontrun{
src <- src_itis()
sql_collect(src, "select * from hierarchy limit 5")
## or pipe the src to sql_collect
src |> sql_collect("select * from hierarchy limit 5")
}
}
