% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load_everything.R
\name{tar_load_everything}
\alias{tar_load_everything}
\title{Load the values of all available targets.}
\usage{
tar_load_everything(
  branches = NULL,
  meta = targets::tar_meta(store = store, fields = -tidyselect::any_of("time")),
  strict = TRUE,
  silent = FALSE,
  envir = parent.frame(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of target metadata from \code{\link[=tar_meta]{tar_meta()}}.}

\item{strict}{Logical of length 1, whether to error out
if one of the selected targets is in the metadata
but cannot be loaded.
Set to \code{FALSE} to just load the targets in the metadata
that can be loaded and skip the others.}

\item{silent}{Logical of length 1. Only relevant when
\code{strict} is \code{FALSE}. If \code{silent} is \code{FALSE}
and \code{strict} is \code{FALSE}, then a message will be printed
if a target is in the metadata but cannot be loaded.
However, load failures
will not stop other targets from being loaded.}

\item{envir}{R environment in which to load target return values.}

\item{store}{Character of length 1, directory path to the data store
of the pipeline.}
}
\value{
Nothing.
}
\description{
Shorthand for \code{tar_load(everything())} to load all
targets with entries in the metadata.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
ls() # Does not have "y1", "y2", or "z".
tar_load_everything()
ls() # Has "y1", "y2", and "z".
})
}
}
\seealso{
Other storage: 
\code{\link{tar_format}()},
\code{\link{tar_load}()},
\code{\link{tar_objects}()},
\code{\link{tar_read}()}
}
\concept{storage}
