% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_deps.R, R/tar_deps_raw.R
\name{tar_deps}
\alias{tar_deps}
\alias{tar_deps_raw}
\title{Code dependencies}
\usage{
tar_deps(expr)

tar_deps_raw(expr)
}
\arguments{
\item{expr}{An R expression or function.
\code{\link[=tar_deps]{tar_deps()}} expects the \code{expr} argument to be an unevaluated
expression,
whereas \code{\link[=tar_deps_raw]{tar_deps_raw()}} expects \code{expr} to be an evaluated
expression object.
Functions can be passed normally in either case.}
}
\value{
Character vector of the dependencies of a function or expression.
}
\description{
List the dependencies of a function or expression.
\code{\link[=tar_deps]{tar_deps()}} expects the \code{expr} argument to be an unevaluated
expression,
whereas \code{\link[=tar_deps_raw]{tar_deps_raw()}} expects \code{expr} to be an evaluated
expression object. Functions can be passed normally in either case.
}
\details{
\code{targets} detects the dependencies of commands using
static code analysis. Use \code{tar_deps()} to run the
code analysis and see the dependencies for yourself.
}
\examples{
tar_deps(x <- y + z)
tar_deps(quote(x <- y + z))
tar_deps({
  x <- 1
  x + a
})
tar_deps(function(a = b) map_dfr(data, ~do_row(.x)))
tar_deps_raw(function(a = b) map_dfr(data, ~do_row(.x)))
}
\seealso{
\code{\link[=tar_branches]{tar_branches()}}, \code{\link[=tar_network]{tar_network()}}

Other inspect: 
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_sitrep}()},
\code{\link{tar_validate}()}
}
\concept{inspect}
