% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fChernoff.R
\name{fChernoff}
\alias{fChernoff}
\title{Chernoff Bound.}
\usage{
fChernoff(ELT, s, t = 1, theta = 0, cap = Inf, nk = 1001,
  verbose = FALSE)
}
\arguments{
\item{ELT}{Data frame containing two numeric columns. The column \code{Loss} contains the expected losses from each single occurrence of event. The column \code{Rate} contains the arrival rates of a single occurrence of event.}

\item{s}{Scalar or numeric vector containing the total losses of interest.}

\item{t}{Scalar representing the time period of interest. The default value is \code{t} = 1.}

\item{theta}{Scalar containing information about the variance of the Gamma distribution: \eqn{sd[X] = x * }\code{theta}. The default value is \code{theta} = 0: the loss associated to an event is considered as a constant.}

\item{cap}{Scalar representing the financial cap on losses for a single event, i.e. the maximum possible loss caused by a single event. The default value is \code{cap} = Inf.}

\item{nk}{Number of optimisation points.}

\item{verbose}{Logical. If \code{TRUE} attaches the minimising index. The default is \code{verbose} = FALSE.}
}
\value{
A numeric matrix, containing the pre-specified losses \code{s} in the first column and the upper bound for the exceedance probabilities in the second column.
}
\description{
Function to bound the total losses via the Chernoff inequality.
}
\details{
Chernoff's inequality states:
\deqn{\Pr(S \geq s) \leq \inf_{k > 0} e^{-k s} M_S(k) }{Pr(S \ge s) \le inf_{k > 0} e^{-k s} M_S(k) }
where \eqn{M_S(k)} is the Moment Generating Function (MGF) of the total loss S.
The \code{fChernoff} function optimises the bound over a fixed set of \code{nk} discrete values.
}
\examples{
data(UShurricane)

# Compress the table to millions of dollars

USh.m <- compressELT(ELT(UShurricane), digits = -6)
EPC.Chernoff <- fChernoff(USh.m, s = 1:40)
EPC.Chernoff
plot(EPC.Chernoff, type = "l", ylim = c(0, 1))
# Assuming the losses follow a Gamma with E[X] = x, and Var[X] = 2 * x
EPC.Chernoff.Gamma <- fChernoff(USh.m, s = 1:40, theta = 2, cap = 5)
EPC.Chernoff.Gamma
plot(EPC.Chernoff.Gamma, type = "l", ylim = c(0, 1))
# Compare the two results:
plot(EPC.Chernoff, type = "l", main = "Exceedance Probability Curve", ylim = c(0, 1))
lines(EPC.Chernoff.Gamma, col = 2, lty = 2)
legend("topright", c("Dirac Delta", expression(paste("Gamma(",
alpha[i] == 1 / theta^2, ", ", beta[i] ==1 / (x[i] * theta^2), ")", " cap =", 5))),
lwd = 2, lty = 1:2, col = 1:2)
}
\keyword{chernoff}

