% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials.R
\name{attention_width}
\alias{attention_width}
\alias{decision_width}
\alias{feature_reusage}
\alias{momentum}
\alias{mask_type}
\alias{num_independent}
\alias{num_shared}
\alias{num_steps}
\title{Parameters for the tabnet model}
\usage{
attention_width(range = c(8L, 64L), trans = NULL)

decision_width(range = c(8L, 64L), trans = NULL)

feature_reusage(range = c(1, 2), trans = NULL)

momentum(range = c(0.01, 0.4), trans = NULL)

mask_type(values = c("sparsemax", "entmax"))

num_independent(range = c(1L, 5L), trans = NULL)

num_shared(range = c(1L, 5L), trans = NULL)

num_steps(range = c(3L, 10L), trans = NULL)
}
\arguments{
\item{range}{the default range for the parameter value}

\item{trans}{whether to apply a transformation to the parameter}

\item{values}{possible values for factor parameters

These functions are used with \code{tune} grid functions to generate
candidates.}
}
\value{
A \code{dials} parameter to be used when tuning TabNet models.
}
\description{
Parameters for the tabnet model
}
\examples{
\dontshow{if ((require("dials") && require("parsnip") && torch::torch_is_installed())) withAutoprint(\{ # examplesIf}
  model <- tabnet(attention_width = tune(), feature_reusage = tune(),
    momentum = tune(), penalty = tune(), rate_step_size = tune()) \%>\%
    parsnip::set_mode("regression") \%>\%
    parsnip::set_engine("torch")
\dontshow{\}) # examplesIf}
}
