% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask-type.R
\name{get_tau}
\alias{get_tau}
\title{Optimal threshold (tau) computation for 1.5-entmax}
\usage{
get_tau(input, dim = -1L, k = NULL)
}
\arguments{
\item{input}{The input tensor to compute thresholds over.}

\item{dim}{The dimension along which to apply 1.5-entmax. Default is -1.}

\item{k}{The number of largest elements to partial-sort over. For optimal
performance, should be slightly bigger than the expected number of
non-zeros in the solution. If the solution is more than k-sparse,
this function is recursively called with a 2*k schedule. If \code{NULL},
full sorting is performed from the beginning. Default is NULL.}
}
\value{
The threshold value for each vector, with all but the \code{dim}
dimension intact.
}
\description{
Optimal threshold (tau) computation for 1.5-entmax
}
