% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxlsx.R
\name{toxlsx}
\alias{toxlsx}
\title{Convert R data frames to excel files}
\usage{
toxlsx(
  object,
  path,
  tosheet = list(),
  title = list(),
  columnstyle = list(default = NULL),
  theme = xls_theme_default(),
  footnote1 = list(),
  footnote2 = list(),
  footnote3 = list(),
  mergecol = NULL,
  bygroup = list(),
  groupname = FALSE,
  filename = "Export",
  asTable = FALSE,
  automaticopen = FALSE
)
}
\arguments{
\item{object}{data.frame to be converted to excel}

\item{path}{path to save excel file (either a directory name or a file name with full path)}

\item{tosheet}{list of sheet names for each element of object.
If omitted, sheets are named by default "Sheet 1", "Sheet 2"...}

\item{title}{list of title for each element of object
If omitted, title takes the name of the dataframe in `object`}

\item{columnstyle}{list of style for columns of each element of object
Only useful if you want to customise the style of each column `}

\item{theme}{styling theme, a named list of `openxlsx` Styles}

\item{footnote1}{list of footnote1 for each element of object
If omitted, no footnote1}

\item{footnote2}{list of footnote2 for each element of object
If omitted, no footnote2}

\item{footnote3}{list of footnote3 for each element of object
If omitted, no footnote3}

\item{mergecol}{list of character vectors that indicate the columns for which we want to merge the modalities}

\item{bygroup}{list of character vectors indicating the names of the columns by which to group}

\item{groupname}{list of booleans indicating whether the names of the grouping variables should be written}

\item{filename}{name for the excel file ("Export" by default). Ignored if `path` is a file name.}

\item{asTable}{logical indicating if data should be written as an Excel Table (FALSE by default)}

\item{automaticopen}{logical indicating if excel file should open automatically (FALSE by default)}
}
\value{
an excel file
}
\description{
This function allows you to write R data frames given
in the `object` argument to excel files located in the `path` directory.
The function takes several arguments but the only two required are `object` and `path`. \cr
See examples gallery : <https://ddotta.github.io/tablexlsx/articles/aa-examples.html>
}
\examples{
# Simply export a data frame to an xlsx file
# For more examples, see examples gallery :
# https://ddotta.github.io/tablexlsx/articles/aa-examples.html
\dontrun{
toxlsx(object = iris, path = tempdir())
}

}
