% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{tablerBlogCard}
\alias{tablerBlogCard}
\title{Create a Boostrap 4 blog card}
\usage{
tablerBlogCard(
  ...,
  title = NULL,
  author = NULL,
  date = NULL,
  href = NULL,
  src = NULL,
  avatarUrl = NULL,
  width = 4,
  horizontal = FALSE
)
}
\arguments{
\item{...}{Any other elements.}

\item{title}{Title.}

\item{author}{Blog post author.}

\item{date}{Date.}

\item{href}{External link.}

\item{src}{Image url.}

\item{avatarUrl}{Avatar image.}

\item{width}{Card width. 4 by default.}

\item{horizontal}{Whether the card is horizontally displayed. FALSE by default.}
}
\description{
Build a tabler blog card
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerBlogCard(
      title = "Blog Card",
      author = "David",
      date = "Today",
      href = "https://www.google.com",
      src = "https://preview.tabler.io/demo/photos/matt-barrett-339981-500.jpg",
      avatarUrl = "https://image.flaticon.com/icons/svg/145/145842.svg",
      width = 6,
      "Look, my liege! The Knights Who Say Ni
      demand a sacrifice! …Are you suggesting
      that coconuts migr..."
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
