% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessCaptionFootnote.R
\name{guessCaptionFootnote}
\alias{guessCaptionFootnote}
\title{guessCaptionFootnote}
\usage{
guessCaptionFootnote(x, MaxCaptionLength = 1, MaxFootnoteLength = 4)
}
\arguments{
\item{x}{character. A file path.}

\item{MaxCaptionLength}{numeric. The maximum number of sentences within a text block that shall be treated as a caption. Text blocks that contain more sentences than this threshold are not extracted.}

\item{MaxFootnoteLength}{numeric. The maximum number of sentences within a text block that shall be treated as a footnote. Text blocks that contain more sentences than this threshold are not extracted.}
}
\value{
A list with the extracted table captions and footers as vectors of length=number of tables.
}
\description{
Extracts text blocks around tables within DOCX, HTML, HML, XML, or NXML files in order to return the table captions and footnotes.
}
\examples{
## Download an example DOCX file from tableParser's github repo to temp directory 
d<-'https://github.com/ingmarboeschen/tableParser/raw/refs/heads/main/tableExamples.docx'
download.file(d,paste0(tempdir(),"/","tableExamples.docx"))

## Download an example HTML file from tableParser's github repo to temp directory 
h<-'https://github.com/ingmarboeschen/tableParser/raw/refs/heads/main/tableExamples.html'
download.file(h,paste0(tempdir(),"/","tableExamples.html"))

## Extract table captions and footnotes 
# DOCX file
\donttest{guessCaptionFootnote(paste0(tempdir(),"/","tableExamples.docx"))}
# HTML file
guessCaptionFootnote(paste0(tempdir(),"/","tableExamples.html"))
}
