% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabe.R
\name{graft}
\alias{graft}
\title{Graft}
\usage{
graft(.data, combine_fun, data2)
}
\arguments{
\item{.data}{A tbl or something that can be coerced into one}

\item{combine_fun}{optional, A function that will combine two tbls such as full_join or bind_rows}

\item{data2}{A tbl or something that can be coerced into one}
}
\value{
A single tbl object
}
\description{
Graft one dataset onto another
}
\details{
Graft requires two data objects.  The first must be provided by the user. The second can either be passed
in or automatically pulled off of the package's internal stack of scions. These will be combined accoring to the following rules in order:
\itemize{
  \item If either dataset has zero rows, the other dataset will be returned.
  \item If combine_fun is specifed, \code{combine_fun(.data, data2)} will be called
  \item If all column names match, a row bind will occur
  \item If at least some column names match, a full join will occur
  \item If both have the same number of rows a column bind will be performed
 }
}
\examples{
library(dplyr)
aframe <- data.frame(zed = runif(100))
set_to_zero <- . \%>\% mutate(zed = 0)
aframe \%>\% scion(zed >0.5, false_fun=set_to_zero) \%>\% mutate(zed=1) \%>\% graft

}
\author{
Seth Wenchel
}
