% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{qsm_volume_distribution}
\alias{qsm_volume_distribution}
\title{Volume distribution from QSM}
\usage{
qsm_volume_distribution(qsm, terminus_diam_cm = 4, segment_size = 0.5)
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{terminus_diam_cm}{numeric - trunk diameter at which it is treated as a branch.}

\item{segment_size}{numeric length of trunk segments in which to summarize volume.}
}
\value{
A tibble describing vertical volume distribution with columns:
\describe{
  \item{section}{Tree component ("trunk", "terminus", or "branches").}
  \item{diam_cm}{Diameter (cm) of the segment or branch.}
  \item{ht_m}{Height (m) of the segment midpoint or branch attachment.}
  \item{volume}{Total volume (m^3) of the segment (trunk and terminus only;
  `NA` for branches).}
}
}
\description{
This function estimates tree volume and its vertical distribution
from a QSM. The function separates the QSM into (1) trunk sections
(2) terminus (top of trunk < 4 cm dbh), and (3) primary branches.
The function divides trunk into segments defined by `segment_size`, calculates QSM volume,
For tree portions identified as branches the function only returns
the diameter. Both of these can be used in mass-volume equations
as needed.
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
volume = qsm_volume_distribution(qsm)
print(volume)
plot(volume~ht_m, data=volume, type='l', xlab='height (m)', ylab='Volume (m3)')
}
