% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Section8}
\alias{Section8}
\alias{swe_deltat_ex}
\alias{swe_deltat}
\alias{swe_set_tid_acc}
\alias{swe_get_tid_acc}
\alias{swe_set_delta_t_userdef}
\title{Section 8: Delta T-related functions}
\usage{
swe_deltat_ex(jd_ut, ephe_flag)

swe_deltat(jd_ut)

swe_set_tid_acc(t_acc)

swe_get_tid_acc()

swe_set_delta_t_userdef(delta_t)
}
\arguments{
\item{jd_ut}{Julian day number (UT) as numeric vector (day)}

\item{ephe_flag}{ephemeris flag as integer (SE$FLG_JPLEPH=1, SE$FLG_SWIEPH=2 or SE$FLG_MOSEPH=4)}

\item{t_acc}{Tidal acceleration as double (arcsec/century^2)}

\item{delta_t}{DeltaT (day)}
}
\value{
\code{swe_deltat_ex} returns a list with named entries: \code{deltat} for DeltaT as double (day)
         and \code{serr} for error message as string.

\code{swe_deltat} returns the DeltaT as double (day)

\code{swe_get_tid_acc} returns the tidal acceleration as double (arcsec/century^2)
}
\description{
Functions related to DeltaT and tidal acceleration
}
\details{
\describe{
\item{swe_deltat_ex()}{Determine DeltaT from Julian day number for a specific ephemeris.}
}

\describe{
\item{swe_deltat()}{Determine DeltaT from Julian day number for a used ephemeris.
This function is only safe if:
  \itemize{
  \item your software consistently uses the same ephemeris flag
  \item if software consistently uses the same ephemeris files (with SE$FLG_SWIEPH and SE$FLG_MOSEPH)
  \item if swe_set_ephe_path() is first called (with SE$FLG_SWIEPH) and swe_set_jpl_file() (with SE$FLG_JPLEPH)
}
}
}

\describe{
\item{swe_set_tid_acc()}{Set the tidal acceleration.}
}

\describe{
\item{swe_get_tid_acc()}{Get the present configured tidal acceleration.}
}

\describe{
\item{swe_set_delta_t_userdef()}{Allows the user to set a fixed DeltaT value that will
be returned by swe_deltat() or swe_deltat_ex().}
}
}
\examples{
data(SE)
swe_deltat_ex(1234.567, SE$FLG_MOSEPH)
swe_deltat(1234.567)
swe_set_tid_acc(1.23)
swe_get_tid_acc()
swe_set_delta_t_userdef(0.23)
}
\seealso{
Section 8 in \url{https://www.astro.com/swisseph/swephprg.htm}. Remember that array indices start in R at 1, while in C they start at 0!
}
