% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Section10}
\alias{Section10}
\alias{swe_set_sid_mode}
\alias{swe_get_ayanamsa_name}
\alias{swe_get_ayanamsa_ex_ut}
\alias{swe_get_ayanamsa_ex}
\title{Section 10: Sidereal mode functions}
\usage{
swe_set_sid_mode(sid_mode, t0, ayan_t0)

swe_get_ayanamsa_name(sid_mode)

swe_get_ayanamsa_ex_ut(jd_ut, iflag)

swe_get_ayanamsa_ex(jd_et, iflag)
}
\arguments{
\item{sid_mode}{Sidereal mode as integer}

\item{t0}{Reference date as double (day)}

\item{ayan_t0}{The initial latitude value of the ayanamsa as double (deg)}

\item{jd_ut}{UT Julian day number as double (day)}

\item{iflag}{Computation flag as integer, many options possible (section 2.3)}

\item{jd_et}{ET Julian day number as double (day)}
}
\value{
\code{swe_get_ayanamsa_name} returns name of ayanamsa method as string

\code{swe_get_ayanamsa_ex_ut} returns a list with named entries: \code{return} status flag as integer,
     \code{daya} ayanamsa value as double and \code{serr} error message as string

\code{swe_get_ayanamsa_ex} returns a list with named entries: \code{return} status flag as integer,
     \code{daya} ayanamsa value as double and \code{serr} error message as string
}
\description{
Functions to support the determination of sidereal information
}
\details{
\describe{
\item{swe_set_sid_mode()}{Set the mode for sidereal computations.}
}

\describe{
\item{swe_get_ayanamsa_name()}{Get the mode name for sidereal computations.}
}

\describe{
\item{swe_get_ayanamsa_ex_ut()}{It computes ayanamsa using UT.}
}

\describe{
\item{swe_get_ayanamsa_ex()}{It computes ayanamsa using ET.}
}
}
\examples{
data(SE)
swe_set_sid_mode(SE$SIDM_FAGAN_BRADLEY,0,0)
swe_get_ayanamsa_name(SE$SIDM_FAGAN_BRADLEY)
swe_get_ayanamsa_ex_ut(2458346.82639,SE$FLG_MOSEPH)
swe_get_ayanamsa_ex(2458346.82639,SE$FLG_MOSEPH)
}
\seealso{
Section 10 in \url{https://www.astro.com/swisseph/swephprg.htm}. Remember that array indices start in R at 1, while in C they start at 0!
}
