% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocities.R
\name{add_velocities}
\alias{add_velocities}
\title{Add Velocity Timeseries Across Sets}
\usage{
add_velocities(data, geo = FALSE, verbose = FALSE, parallelize = FALSE)
}
\arguments{
\item{data}{A data frame with time series of individual's positional data,
as exported by the \code{set_data_format} function.
Columns needed: \code{set}, \code{t}, \code{id}, \code{x}, \code{y}.}

\item{geo}{Logical, whether positions are geographic coordinates,
default = FALSE.}

\item{verbose}{Logical, whether to post updates on progress, default = FALSE.}

\item{parallelize}{Logical, whether to run the function in parallel over individuals,
default = FALSE.}
}
\value{
A list of dataframes, an element per set from the input dataframe
with new columns: \code{head} and \code{speed}.
}
\description{
This function calculates and adds the speed and heading of each individual
over time in the dataset, and splits it in a list of dataframes based
on the defined sets.
}
\examples{
data <- data.frame(
set = rep(1, 25),
x = rnorm(25, sd = 3),
y = rnorm(25, sd = 3),
t = as.POSIXct(1:25, origin = Sys.time()),
id = rep(1, 25)
)

data_list <- add_velocities(data, geo = FALSE)

}
\seealso{
\code{\link{add_set_vels}}, \code{\link{set_data_format}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
