% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svycoxme.R
\name{svycoxme}
\alias{svycoxme}
\alias{svycoxme.DBIsvydesign}
\alias{svycoxme.survey.design}
\alias{svycoxme.svyrep.design}
\title{Survey-weighted mixed-effects Cox models}
\usage{
svycoxme(
  formula,
  design,
  subset = NULL,
  rescale = TRUE,
  control = coxme::coxme.control(),
  ...
)

\method{svycoxme}{DBIsvydesign}(
  formula,
  design,
  subset = NULL,
  rescale = TRUE,
  control = coxme::coxme.control(),
  ...
)

\method{svycoxme}{survey.design}(
  formula,
  design,
  subset = NULL,
  rescale = TRUE,
  control = coxme::coxme.control(),
  ...
)

\method{svycoxme}{svyrep.design}(
  formula,
  design,
  subset = NULL,
  rescale = TRUE,
  control = coxme::coxme.control(),
  multicore = getOption("survey.multicore"),
  return.replicates = FALSE,
  ...
)
}
\arguments{
\item{formula}{Model formula.}

\item{design}{\code{survey.design} object. It must contain all variables in the formula.}

\item{subset}{Expression to select a subpopulation.}

\item{rescale}{Rescale weights to improve numerical stability.}

\item{control}{Optional list of \code{\link[coxme]{coxme}} control options. See \code{\link[coxme]{coxme.control}} for details.}

\item{...}{Other arguments passed to \code{\link[coxme]{coxme}}.}

\item{multicore}{For replicate weight designs. Should parallel processing be used?}

\item{return.replicates}{For replicate weight designs. Should replicates be returned?}
}
\value{
An object of class \code{svycoxme}.
}
\description{
Fit a mixed-effect proportional hazards model to data from a complex design.
}
\details{
Parallel processing is done with \code{\link[future.apply]{future_lapply}}. Future planning
is left to the user, e.g. using \code{\link[future]{plan}} before the call to \code{svycoxme}.
Note that \code{svycoxme.DBIsvydesign} has not been implemented yet.
}
\examples{
des <- survey::svydesign(ids = ~group_id, weights = ~weight, data = samp_srcs)
fit1 <- svycoxme(survival::Surv(stat_time, stat) ~ X1 + X2 + X3 + (1 | group_id),
                 design = des)
summary(fit1)

# with replicate weights (only 10 replicates are used to reduce CPU time)
repdes <- survey::as.svrepdesign(des, type = "bootstrap", replicates = 10)
fit2 <- svycoxme(survival::Surv(stat_time, stat) ~ X1 + X2 + X3 + (1 | group_id),
                 design = repdes)
summary(fit2)

# use multicore processing (`n_cores = 2` to comply with CRAN policy). Otherwise,
# something like, `floor(parallelly::availableCores() * 0.8)`, could be used.

n_cores = 2
future::plan("multicore", workers = n_cores)
fit3 <- svycoxme(survival::Surv(stat_time, stat) ~ X1 + X2 + X3 + (1 | group_id),
                 design = repdes, multicore = TRUE)
all.equal(coef(fit2), coef(fit3))
future::plan("sequential")

}
