% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-functions.R
\name{get_rep_type}
\alias{get_rep_type}
\title{Access Type of Replication Method}
\usage{
get_rep_type(rep_design)
}
\arguments{
\item{rep_design}{A replicate design object}
}
\value{
A character string giving the
type of replication method.
}
\description{
Identify the type of replication
method used for the replicates in a 
replicate design object.
}
\examples{
data('scd', package = 'survey')

scd_design <- svydesign(
  data   = scd, 
  id     = ~ ambulance, 
  prob   = ~ 1,
  strata = ~ ESA,
  nest   = TRUE
)

scd_design |>
  as_bootstrap_design(replicates = 5) |>
  get_rep_type()

scd_design |>
  as_fays_gen_rep_design(
    variance_estimator = "Ultimate Cluster"
  ) |>
  get_rep_type()

}
