% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_labelling.R
\name{fig_id}
\alias{fig_id}
\alias{fig_id_auto}
\title{Create a figure id from a chunk label}
\usage{
fig_id(label)

fig_id_auto()
}
\arguments{
\item{label}{The label to use. If provided, it supersedes the chunk label.}
}
\value{
A string to set the id like id="fig:label". For \code{\link[=fig_id_auto]{fig_id_auto()}},
the function installs a hook in 'knitr' to add an id automatically for each
plot make by changing \verb{out.extra=}.
}
\description{
This function looks at the current chunk label and returns id="fig:label"
that is usable in the \verb{out.extra=} field of the R chunk. It allows to refer
to a figure generated from a chunk with this label. Use
\code{out.extra=chunk_id()} to set the id, or use \code{fig_id_auto()}.
}
\examples{
fig_id("my_label")
}
