% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admininfo.R
\name{adminInfo}
\alias{adminInfo}
\title{Get admin information}
\usage{
adminInfo(
  poly.adm,
  by.adm,
  admin,
  by.adm.upper = NULL,
  agg.pop = NULL,
  proportion = NULL
)
}
\arguments{
\item{poly.adm}{spatial polygons dataframe for Admin levels such as Admin 1 or Admin 2. This object can be either an sp::SpatialPolygonsDataFrame object or an sf object.}

\item{by.adm}{the column name of column for Admin names for desired output Admin level, can be such as "NAME_1" or "NAME_2".}

\item{admin}{desired admin level for the output, can be 1 or 2.}

\item{by.adm.upper}{the column name of column for Admin names for upper level of your desired output Admin level when admin=2, can be "NAME_1" when by.adm="NAME_2".}

\item{agg.pop}{data frame of aggregated poplulation from aggPopulation function. It should have two columns: "admin2.name.full" and "population".}

\item{proportion}{data frame of urban/rural proportions. For admin1, is should have two columns: "admin1.name" and "urban". For admin2, it should have three columns: "admin1.name", "admin2.name", and "urban", in order to avoid issues merging datasets with duplicated admin2 names.}
}
\value{
This function returns the 1. dataframe that contains admin 1 and admin 2 information and coordinates for each cluster and 2. Adjacency matrix.
}
\description{
This function get admin information including name, character, population and unban/rural proportion.
}
\examples{

# For sp::SpatialPolygonsDataFrame object
data(ZambiaAdm1)
class(ZambiaAdm1)
info <- adminInfo(poly.adm=ZambiaAdm1, admin = 1, by.adm="NAME_1")
data(ZambiaAdm2)
class(ZambiaAdm2)
info2 <- adminInfo(poly.adm=ZambiaAdm2, admin = 2,by.adm="NAME_2",by.adm.upper="NAME_1")

# For sf object
geo.sf <- sf::st_as_sf(ZambiaAdm1)
info <- adminInfo(poly.adm=geo.sf, admin = 1,by.adm="NAME_1")

# To include the population information
data(ZambiaPopWomen)
info <- adminInfo(poly.adm = ZambiaAdm1,
                  admin = 1,by.adm="NAME_1",
                  agg.pop = ZambiaPopWomen$admin1_pop,
                  proportion = ZambiaPopWomen$admin1_urban )
}
\author{
Qianyu Dong
}
