% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_parts.R
\name{predict_parts}
\alias{predict_parts}
\alias{predict_parts.surv_explainer}
\title{Instance Level Parts of Survival Model Predictions}
\usage{
predict_parts(explainer, ...)

\method{predict_parts}{surv_explainer}(
  explainer,
  new_observation,
  ...,
  N = NULL,
  type = "survshap",
  output_type = "survival",
  explanation_label = NULL
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{...}{other parameters which are passed to \code{iBreakDown::break_down} if \code{output_type=="risk"}, or if \code{output_type=="survival"} to \code{surv_shap()} or \code{surv_lime()} functions depending on the selected type}

\item{new_observation}{a new observation for which prediction need to be explained}

\item{N}{the number of observations used for calculation of attributions. If \code{NULL} (default) all explainer data will be used for SurvSHAP(t) and 100 neigbours for SurvLIME.}

\item{type}{if \code{output_type == "survival"} must be either \code{"survshap"} or \code{"survlime"}, otherwise refer to the \code{DALEX::predict_parts}}

\item{output_type}{either \code{"survival"}, \code{"chf"} or \code{"risk"} the type of survival model output that should be considered for explanations. If \code{"survival"} the explanations are based on the survival function. If \code{"chf"} the explanations are based on the cumulative hazard function. Otherwise the scalar risk predictions are used by the \code{DALEX::predict_parts} function.}

\item{explanation_label}{a label that can overwrite explainer label (useful for multiple explanations for the same explainer/model)}
}
\value{
An object of class \code{"predict_parts_survival"} and additional classes depending on the type of explanations. It is a list with the element \code{result} containing the results of the calculation.
}
\description{
This function decomposes the model prediction into individual parts, which are attributions of particular variables. The explanations can be made via the SurvLIME and SurvSHAP(t) methods.
}
\section{Additional parameters}{


There are additional parameters that are passed to internal functions
\itemize{
\item for \code{survlime}
\itemize{
\item \code{N} -  a positive integer, number of observations generated in the neighbourhood
\item \code{distance_metric} -  character, name of the distance metric to be used, only \code{"euclidean"} is implemented
\item \code{kernel_width} -  a numeric, parameter used for calculating weights, by default it's \code{sqrt(ncol(data)*0.75)}
\item \code{sampling_method} -  character, name of the method of generating neighbourhood, only \code{"gaussian"} is implemented
\item \code{sample_around_instance} -  logical, if the neighbourhood should be generated with the new observation as the center (default), or should the mean of the whole dataset be used as the center
\item \code{max_iter} -  a numeric, maximal number of iteration for the optimization problem
\item \code{categorical_variables} -  character vector, names of variables that should be treated as categories (factors are included by default)
\item \code{k} -  a small positive number > 1, added to chf before taking log, so that weigths aren't negative
}
\item for \code{survshap}
\itemize{
\item \code{y_true} -  a two element numeric vector or matrix of one row and two columns, the first element being the true observed time and the second the status of the observation, used for plotting
\item \code{calculation_method} -  a character, either \code{"kernelshap"} for use of \code{kernelshap} library (providing faster Kernel SHAP with refinements) or \code{"exact_kernel"} for exact Kernel SHAP estimation
\item \code{aggregation_method} -  a character, either \code{"mean_absolute"} or \code{"integral"}, \code{"max_absolute"}, \code{"sum_of_squares"}
}
}
}

\section{References}{

\itemize{
\item [1] Krzyziński, Mateusz, et al. \href{https://www.sciencedirect.com/science/article/pii/S0950705122013302}{"SurvSHAP(t): Time-dependent explanations of machine learning survival models."} Knowledge-Based Systems 262 (2023): 110234
\item [2] Kovalev, Maxim S., et al. \href{https://www.sciencedirect.com/science/article/pii/S0950705120304044?casa_token=6e9cyk_ji3AAAAAA:tbqo33MsZvNC9nrSGabZdLfPtZTsvsvZTHYQCM2aEhumLI5D46U7ovhr37EaYUhmKZrw45JzDhg}{"SurvLIME: A method for explaining machine learning survival models."} Knowledge-Based Systems 203 (2020): 106164.
}
}

\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

cph_predict_parts_survshap <- predict_parts(cph_exp, new_observation = veteran[1, -c(3, 4)])
head(cph_predict_parts_survshap$result)
plot(cph_predict_parts_survshap)

cph_predict_parts_survlime <- predict_parts(
    cph_exp,
    new_observation = veteran[1, -c(3, 4)],
    type = "survlime"
)
head(cph_predict_parts_survlime$result)
plot(cph_predict_parts_survlime, type = "local_importance")
}

}
